/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.history;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.pokesplash.gts.Listing.ItemListing;
import org.pokesplash.gts.Listing.Listing;
import org.pokesplash.gts.Listing.PokemonListing;
import org.pokesplash.gts.api.provider.HistoryAPI;
import org.pokesplash.gts.history.History;
import org.pokesplash.gts.history.HistoryItem;
import org.pokesplash.gts.history.ItemHistoryItem;
import org.pokesplash.gts.history.PokemonHistoryItem;
import org.pokesplash.gts.oldVersion.PlayerHistoryOld;
import org.pokesplash.gts.util.Utils;

public class PlayerHistory
implements History {
    private UUID player;
    private List<HistoryItem> listings;

    public PlayerHistory(UUID playerUUID) {
        this.player = playerUUID;
        this.listings = new ArrayList<HistoryItem>();
        if (HistoryAPI.getHighestPriority() == null) {
            Utils.checkForDirectory("/config/gts/history/" + String.valueOf(playerUUID) + "/");
        }
    }

    public PlayerHistory(UUID player, ArrayList<HistoryItem> items) {
        this.player = player;
        this.listings = items;
    }

    public PlayerHistory(PlayerHistoryOld playerHistoryOld) {
        HistoryItem item;
        this.player = playerHistoryOld.getPlayer();
        this.listings = new ArrayList<HistoryItem>();
        for (PokemonListing pokemonListing : playerHistoryOld.getPokemonListings()) {
            pokemonListing.update(true);
            item = new PokemonHistoryItem(pokemonListing, "Unknown");
            item.write();
            this.listings.add(item);
        }
        for (ItemListing itemListing : playerHistoryOld.getItemListings()) {
            itemListing.update(false);
            item = new ItemHistoryItem(itemListing, "Unknown");
            item.write();
            this.listings.add(item);
        }
    }

    @Override
    public UUID getPlayer() {
        return this.player;
    }

    public List<HistoryItem> getListings() {
        return this.listings;
    }

    public List<PokemonHistoryItem> getPokemonListings() {
        ArrayList<PokemonHistoryItem> pokemonListings = new ArrayList<PokemonHistoryItem>();
        for (HistoryItem listing : this.listings) {
            if (!listing.isPokemon()) continue;
            pokemonListings.add((PokemonHistoryItem)listing);
        }
        return pokemonListings;
    }

    public List<ItemHistoryItem> getItemListings() {
        ArrayList<ItemHistoryItem> itemListings = new ArrayList<ItemHistoryItem>();
        for (HistoryItem listing : this.listings) {
            if (listing.isPokemon()) continue;
            itemListings.add((ItemHistoryItem)listing);
        }
        return itemListings;
    }

    public void addListing(Listing listing, String buyerName) {
        HistoryItem item = listing.isPokemon() ? new PokemonHistoryItem((PokemonListing)listing, buyerName) : new ItemHistoryItem((ItemListing)listing, buyerName);
        item.write();
        this.listings.add(item);
    }

    public void addHistory(HistoryItem historyItem) {
        this.listings.add(historyItem);
    }

    public void writeAll() {
        for (HistoryItem item : this.listings) {
            item.write();
        }
    }
}

